package gov.va.med.mhv.sm.admin.enums;

public enum ReportingCountsTypeEnum {

	COUNTS (0, "COUNTS"),
	TRENDS (1, "TRENDS"),
	DASHBOARD (1, "DASHBOARD");
	
	private int id;
	private String name;
	
	private ReportingCountsTypeEnum(int id, String name){
		this.id = id;
		this.name = name;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static ReportingCountsTypeEnum valueOf(Long value){
		for(ReportingCountsTypeEnum f : ReportingCountsTypeEnum.values()){
			if(f.getId()==value)
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no reporting counts type found");
	}
	
}
